/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TempleAltisaurPreventEffect
extends PreventionEffectImpl {
    TempleAltisaurPreventEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If a source would deal damage to another Dinosaur you control, prevent all but 1 of that damage";
        this.consumable = false;
    }

    private TempleAltisaurPreventEffect(TempleAltisaurPreventEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int damage = event.getAmount();
        if (damage > 1) {
            this.amountToPrevent = damage - 1;
            this.preventDamageAction(event, source, game);
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && !permanent.getId().equals(source.getSourceId()) && permanent.hasSubtype(SubType.DINOSAUR, game) && permanent.isControlledBy(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public TempleAltisaurPreventEffect copy() {
        return new TempleAltisaurPreventEffect(this);
    }
}

