/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.BecomesTappedTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DontUntapInControllersUntapStepAllEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.t.TemporalDistortionRemovalEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;

public final class TemporalDistortion
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("a creature or land");
    private static final FilterPermanent filter2 = new FilterPermanent("permanents with hourglass counters on them");

    public TemporalDistortion(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{U}{U}");
        AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.HOURGLASS.createInstance());
        effect.setText("put an hourglass counter on it");
        this.addAbility((Ability)new BecomesTappedTriggeredAbility((Effect)effect, false, filter, true));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new DontUntapInControllersUntapStepAllEffect(Duration.WhileOnBattlefield, TargetController.ANY, filter2).setText("each permanent with an hourglass counter on it doesn't untap during its controller's untap step")));
        this.addAbility((Ability)new BeginningOfUpkeepTriggeredAbility(TargetController.EACH_PLAYER, (Effect)new TemporalDistortionRemovalEffect(), false));
    }

    private TemporalDistortion(TemporalDistortion card) {
        super((CardImpl)card);
    }

    public TemporalDistortion copy() {
        return new TemporalDistortion(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.LAND.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
        filter2.add((Predicate)CounterType.HOURGLASS.getPredicate());
    }
}

