/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.OnLeaveReturnExiledAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TemporaryLockdownEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent();

    TemporaryLockdownEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile each nonland permanent with mana value 2 or less until {this} leaves the battlefield";
    }

    private TemporaryLockdownEffect(TemporaryLockdownEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemporaryLockdownEffect copy() {
        return new TemporaryLockdownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || source.getSourcePermanentIfItStillExists(game) == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OnLeaveReturnExiledAbility(), source);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

