/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TemptWithGloryEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();
    private static final Counter counter = CounterType.P1P1.createInstance();

    public TemptWithGloryEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "<i>Tempting offer</i> &mdash; Put a +1/+1 counter on each creature you control. Each opponent may put a +1/+1 counter on each creature they control. For each opponent who does, put a +1/+1 counter on each creature you control";
    }

    private TemptWithGloryEffect(TemptWithGloryEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptWithGloryEffect copy() {
        return new TemptWithGloryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            this.addCounterToEachCreature(controller.getId(), counter, source, game);
            int opponentsAddedCounters = 0;
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(playerId);
                if (opponent == null || !opponent.chooseUse(this.outcome, "Put a +1/+1 counter on each creature you control?", source, game)) continue;
                ++opponentsAddedCounters;
                this.addCounterToEachCreature(playerId, counter, source, game);
                game.informPlayers(opponent.getLogName() + " added a +1/+1 counter on each of its creatures");
            }
            if (opponentsAddedCounters > 0) {
                this.addCounterToEachCreature(controller.getId(), CounterType.P1P1.createInstance(opponentsAddedCounters), source, game);
            }
            return true;
        }
        return false;
    }

    private void addCounterToEachCreature(UUID playerId, Counter counter, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, playerId, game)) {
            permanent.addCounters(counter, playerId, source, game);
        }
    }
}

