/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;

class TemptingWurmEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("any number of artifact, creature, enchantment, and/or land cards");

    TemptingWurmEffect() {
        super(Outcome.Detriment);
        this.staticText = "each opponent may put any number of artifact, creature, enchantment, and/or land cards from their hand onto the battlefield.";
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl();
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Target target;
                Player opponent = game.getPlayer(playerId);
                if (opponent == null || !(target = new TargetCard(0, Integer.MAX_VALUE, Zone.HAND, filter).withChooseHint("put from hand to battlefield")).chooseTarget(Outcome.PutCardInPlay, opponent.getId(), source, game)) continue;
                for (UUID cardId : target.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    cards.add(card);
                }
            }
            controller.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }

    private TemptingWurmEffect(TemptingWurmEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptingWurmEffect copy() {
        return new TemptingWurmEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

