/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TenthDistrictHeroEffect
extends ContinuousEffectImpl {
    TenthDistrictHeroEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "if {this} is a Detective, it becomes a legendary creature named Mileva, the Stalwart, it has base power and toughness 5/5, and it gains \"Other creatures you control have indestructible.\"";
    }

    private TenthDistrictHeroEffect(TenthDistrictHeroEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TenthDistrictHeroEffect copy() {
        return new TenthDistrictHeroEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.DETECTIVE, game)) {
            this.discard();
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TextChangingEffects_3: {
                permanent.setName("Mileva, the Stalwart");
                return true;
            }
            case TypeChangingEffects_4: {
                permanent.addSuperType(game, SuperType.LEGENDARY);
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.WhileOnBattlefield, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, true)), source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(5);
                permanent.getToughness().setModifiedBaseValue(5);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TextChangingEffects_3: 
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

