/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class TerashisGrasp
extends CardImpl {
    public TerashisGrasp(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{W}");
        this.subtype.add((Object)SubType.ARCANE);
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_ENCHANTMENT));
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addEffect((Effect)new TerashisGraspEffect());
    }

    private TerashisGrasp(TerashisGrasp card) {
        super((CardImpl)card);
    }

    public TerashisGrasp copy() {
        return new TerashisGrasp(this);
    }

    private static class TerashisGraspEffect
    extends OneShotEffect {
        public TerashisGraspEffect() {
            super(Outcome.DestroyPermanent);
            this.staticText = "You gain life equal to its mana value";
        }

        private TerashisGraspEffect(TerashisGraspEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            Permanent targetPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if (targetPermanent != null) {
                int cost = targetPermanent.getManaValue();
                Player player = game.getPlayer(source.getControllerId());
                if (player != null) {
                    player.gainLife(cost, game, source);
                }
            }
            return true;
        }

        public TerashisGraspEffect copy() {
            return new TerashisGraspEffect(this);
        }
    }
}

