/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TerminusEffect
extends OneShotEffect {
    TerminusEffect() {
        super(Outcome.Removal);
        this.staticText = "Put all creatures on the bottom of their owners' libraries";
    }

    private TerminusEffect(TerminusEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerminusEffect copy() {
        return new TerminusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new OwnerIdPredicate(player.getId()));
            CardsImpl toLib = new CardsImpl();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                toLib.add((Card)permanent);
            }
            player.putCardsOnBottomOfLibrary((Cards)toLib, game, source, true);
        }
        return true;
    }
}

