/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TerritorialAetherkiteEffect
extends OneShotEffect {
    TerritorialAetherkiteEffect() {
        super(Outcome.Benefit);
        this.staticText = "you get {E}{E}. Then you may pay one or more {E}. When you do, this creature deals that much damage to each other creature";
    }

    TerritorialAetherkiteEffect(TerritorialAetherkiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public TerritorialAetherkiteEffect copy() {
        return new TerritorialAetherkiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent aetherkite = game.getPermanent(source.getSourceId());
        if (controller == null || aetherkite == null) {
            return false;
        }
        new GetEnergyCountersControllerEffect(2).apply(game, source);
        int energyToPay = controller.getAmount(0, controller.getCountersCount(CounterType.ENERGY), "Pay any amount of {E}", source, game);
        if (energyToPay == 0) {
            return true;
        }
        PayEnergyCost cost = new PayEnergyCost(energyToPay);
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("each other creature");
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        new DamageAllEffect(energyToPay, (FilterPermanent)filter).apply(game, source);
        return true;
    }
}

