/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class TerrorOfThePeaksCostIncreaseEffect
extends CostModificationEffectImpl {
    TerrorOfThePeaksCostIncreaseEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Spells your opponents cast that target {this} cost an additional 3 life to cast";
    }

    private TerrorOfThePeaksCostIncreaseEffect(TerrorOfThePeaksCostIncreaseEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        abilityToModify.addCost((Cost)new PayLifeCost(3));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Set allTargets;
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        if (!game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId())) {
            return false;
        }
        Spell spell = (Spell)game.getStack().getStackObject(abilityToModify.getId());
        if (spell != null) {
            allTargets = CardUtil.getAllSelectedTargets((Ability)abilityToModify, (Game)game);
        } else {
            allTargets = CardUtil.getAllPossibleTargets((Ability)abilityToModify, (Game)game);
            if (allTargets.stream().anyMatch(target -> !this.isTargetCompatible((UUID)target, source, game))) {
                return false;
            }
        }
        return allTargets.stream().anyMatch(target -> this.isTargetCompatible((UUID)target, source, game));
    }

    private boolean isTargetCompatible(UUID target, Ability source, Game game) {
        return Objects.equals(source.getSourceId(), target);
    }

    public TerrorOfThePeaksCostIncreaseEffect copy() {
        return new TerrorOfThePeaksCostIncreaseEffect(this);
    }
}

