/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.permanent.Permanent;

class TestOfFaithPreventDamageTargetEffect
extends PreventionEffectImpl {
    private int amount = 3;

    public TestOfFaithPreventDamageTargetEffect(Duration duration) {
        super(duration);
        this.staticText = "Prevent the next 3 damage that would be dealt to target creature this turn. For each 1 damage prevented this way, put a +1/+1 counter on that creature";
    }

    private TestOfFaithPreventDamageTargetEffect(TestOfFaithPreventDamageTargetEffect effect) {
        super((PreventionEffectImpl)effect);
        this.amount = effect.amount;
    }

    public TestOfFaithPreventDamageTargetEffect copy() {
        return new TestOfFaithPreventDamageTargetEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage());
        if (!game.replaceEvent((GameEvent)preventEvent)) {
            Permanent targetPermanent;
            int damage;
            int prevented = 0;
            if (event.getAmount() >= this.amount) {
                damage = this.amount;
                event.setAmount(event.getAmount() - this.amount);
                this.used = true;
                game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
                prevented = damage;
            } else {
                damage = event.getAmount();
                event.setAmount(0);
                this.amount -= damage;
                game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
                prevented = damage;
            }
            if (prevented > 0 && (targetPermanent = game.getPermanent(source.getTargets().getFirstTarget())) != null) {
                targetPermanent.addCounters(CounterType.P1P1.createInstance(prevented), source.getControllerId(), source, game);
                game.informPlayers("Test of Faith: Prevented " + prevented + " damage ");
                game.informPlayers("Test of Faith: Adding " + prevented + " +1/+1 counters to " + targetPermanent.getName());
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            return source.getTargets().getFirstTarget().equals(event.getTargetId());
        }
        return false;
    }
}

