/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.common.ExileTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.t.TetravusPredicate;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;

class TetravusAddCountersEffect
extends OneShotEffect {
    TetravusAddCountersEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile any number of tokens created with {this}. If you do, put that many +1/+1 counters on {this}";
    }

    private TetravusAddCountersEffect(TetravusAddCountersEffect effect) {
        super((OneShotEffect)effect);
    }

    public TetravusAddCountersEffect copy() {
        return new TetravusAddCountersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        FilterControlledPermanent filter = new FilterControlledPermanent("tokens created with " + permanent.getName());
        filter.add((Predicate)new TetravusPredicate(new MageObjectReference((MageObject)permanent, game)));
        filter.add((Predicate)TokenPredicate.TRUE);
        ExileTargetCost cost = new ExileTargetCost(new TargetControlledPermanent(0, Integer.MAX_VALUE, filter, true));
        if (cost.pay(source, game, source, player.getId(), true)) {
            return new AddCountersSourceEffect(CounterType.P1P1.createInstance(cost.getPermanents().size())).apply(game, source);
        }
        return false;
    }
}

