/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class TevalTheBalancedScaleEffect
extends OneShotEffect {
    TevalTheBalancedScaleEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may return a land card from your graveyard to the battlefield tapped";
    }

    private TevalTheBalancedScaleEffect(TevalTheBalancedScaleEffect effect) {
        super((OneShotEffect)effect);
    }

    public TevalTheBalancedScaleEffect copy() {
        return new TevalTheBalancedScaleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND, true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

