/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ThassasEmissaryTriggeredAbility
extends TriggeredAbilityImpl {
    public ThassasEmissaryTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever {this} or enchanted creature deals combat damage to a player, ");
    }

    private ThassasEmissaryTriggeredAbility(ThassasEmissaryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ThassasEmissaryTriggeredAbility copy() {
        return new ThassasEmissaryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (((DamagedEvent)event).isCombatDamage()) {
            if (event.getSourceId().equals(this.sourceId)) {
                return true;
            }
            Permanent p = game.getPermanent(event.getSourceId());
            if (p != null && p.getAttachments().contains(this.getSourceId())) {
                return true;
            }
        }
        return false;
    }
}

