/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DevotionCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class ThassasOracleEffect
extends OneShotEffect {
    ThassasOracleEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top X cards of your library, where X is your devotion to blue. Put up to one of them on top of your library and the rest on the bottom of your library in a random order. If X is greater than or equal to the number of cards in your library, you win the game";
    }

    private ThassasOracleEffect(ThassasOracleEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThassasOracleEffect copy() {
        return new ThassasOracleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.getLibrary().size() == 0) {
            player.won(game);
            return true;
        }
        int xValue = DevotionCount.U.calculate(game, source, (Effect)this);
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, StaticFilters.FILTER_CARD);
        player.choose(Outcome.DrawCard, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        cards.remove(card);
        player.putCardsOnTopOfLibrary((Cards)new CardsImpl(card), game, source, false);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        if (xValue >= player.getLibrary().size()) {
            player.won(game);
        }
        return true;
    }
}

