/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ThatcherHumanToken;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ThatcherRevoltEffect
extends OneShotEffect {
    ThatcherRevoltEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create three 1/1 red Human creature tokens with haste. Sacrifice those tokens at the beginning of the next end step";
    }

    private ThatcherRevoltEffect(ThatcherRevoltEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThatcherRevoltEffect copy() {
        return new ThatcherRevoltEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ThatcherHumanToken token = new ThatcherHumanToken();
        token.putOntoBattlefield(3, game, source, source.getControllerId());
        ArrayList<Permanent> toSacrifice = new ArrayList<Permanent>();
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent tokenPermanent = game.getPermanent(tokenId);
            if (tokenPermanent == null) continue;
            toSacrifice.add(tokenPermanent);
        }
        SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect();
        sacrificeEffect.setTargetPointer((TargetPointer)new FixedTargets(toSacrifice, game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect), source);
        return true;
    }
}

