/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TheAesirEscapeValhallaTwoEffect
extends OneShotEffect {
    TheAesirEscapeValhallaTwoEffect() {
        super(Outcome.Neutral);
        this.staticText = "Put a number of +1/+1 counters on target creature you control equal to the mana value of the exiled card";
    }

    private TheAesirEscapeValhallaTwoEffect(TheAesirEscapeValhallaTwoEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheAesirEscapeValhallaTwoEffect copy() {
        return new TheAesirEscapeValhallaTwoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        int mv = 0;
        for (Card card : exileZone.getCards(game)) {
            mv += card.getManaValue();
        }
        UUID uuid = this.getTargetPointer().getFirst(game, source);
        Permanent permanent = game.getPermanent(uuid);
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(mv), source.getControllerId(), source, game);
            game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " puts " + mv + " +1/+1 counters on " + permanent.getLogName());
        }
        return true;
    }
}

