/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.StaticHint;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class TheAncientOneEffect
extends OneShotEffect {
    TheAncientOneEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card, then discard a card. When you discard a card this way, target player mills cards equal to its mana value";
    }

    private TheAncientOneEffect(TheAncientOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheAncientOneEffect copy() {
        return new TheAncientOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        Card discarded = controller.discardOne(false, false, source, game);
        if (discarded == null) {
            return true;
        }
        int amount = discarded.getManaValue();
        ReflexiveTriggeredAbility trigger = new ReflexiveTriggeredAbility((Effect)new MillCardsTargetEffect(amount).setText("target player mills cards equal to its mana value"), false);
        trigger.addHint((Hint)new StaticHint("Mana value of the discarded card: " + amount));
        trigger.addTarget((Target)new TargetPlayer());
        trigger.setTriggerPhrase("When you discard a card this way, ");
        game.fireReflexiveTriggeredAbility(trigger, source);
        return true;
    }
}

