/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheAntiquitiesWarEffect
extends ContinuousEffectImpl {
    TheAntiquitiesWarEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "Artifacts you control become artifact creatures with base power and toughness 5/5 until end of turn";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private TheAntiquitiesWarEffect(TheAntiquitiesWarEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheAntiquitiesWarEffect copy() {
        return new TheAntiquitiesWarEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        for (Permanent perm : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT, source.getControllerId(), source, game)) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)perm, game));
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (MageObjectReference mor : this.affectedObjectList) {
            Permanent permanent = mor.getPermanent(game);
            if (permanent == null) continue;
            switch (layer) {
                case TypeChangingEffects_4: {
                    if (sublayer != SubLayer.NA) break;
                    if (!permanent.isArtifact(game)) {
                        permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                    }
                    if (permanent.isCreature(game)) break;
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(5);
                    permanent.getToughness().setModifiedBaseValue(5);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }
}

