/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TheBattleOfEndorEffect
extends OneShotEffect {
    TheBattleOfEndorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put X +1/+1 counters on each creature you control";
    }

    private TheBattleOfEndorEffect(TheBattleOfEndorEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBattleOfEndorEffect copy() {
        return new TheBattleOfEndorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), source.getControllerId(), source, game)) {
                permanent.addCounters(CounterType.P1P1.createInstance(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

