/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.LinkedList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TheBattleOfYavinEffect
extends OneShotEffect {
    TheBattleOfYavinEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "For each nonland permanent target opponent controls, that player sacrificies it unless they pay X life";
    }

    private TheBattleOfYavinEffect(TheBattleOfYavinEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBattleOfYavinEffect copy() {
        return new TheBattleOfYavinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getTargets().getFirstTarget());
        if (opponent == null) {
            return false;
        }
        int amount = GetXValue.instance.calculate(game, source, (Effect)this);
        if (amount > 0) {
            Player player;
            LinkedList<Permanent> sacrifices = new LinkedList<Permanent>();
            FilterNonlandPermanent filter = new FilterNonlandPermanent();
            List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, opponent.getId(), game);
            int lifePaid = 0;
            int playerLife = opponent.getLife();
            for (Permanent permanent : permanents) {
                String message = "Pay " + amount + " life? If you don't, " + permanent.getName() + " will be sacrificed.";
                if (playerLife - amount - lifePaid >= 0 && opponent.chooseUse(Outcome.Neutral, message, source, game)) {
                    game.informPlayers(opponent.getLogName() + " pays " + amount + " life. They will not sacrifice " + permanent.getName());
                    lifePaid += amount;
                    continue;
                }
                game.informPlayers(opponent.getLogName() + " will sacrifice " + permanent.getName());
                sacrifices.add(permanent);
            }
            if (lifePaid > 0 && (player = game.getPlayer(opponent.getId())) != null) {
                player.loseLife(lifePaid, game, source, false);
            }
            for (Permanent permanent : sacrifices) {
                permanent.sacrifice(source, game);
            }
        }
        return true;
    }
}

