/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheBearsOfLittjaraEffect
extends OneShotEffect {
    TheBearsOfLittjaraEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose up to one target creature or planeswalker. Each creature with power 4 or greater you control deals damage equal to its power to that permanent.";
    }

    private TheBearsOfLittjaraEffect(TheBearsOfLittjaraEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheBearsOfLittjaraEffect copy() {
        return new TheBearsOfLittjaraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            int power;
            if (creature == null || (power = creature.getPower().getValue()) < 4) continue;
            permanent.damage(power, creature.getId(), source, game);
        }
        return true;
    }
}

