/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.UntapSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheBeastDeathlessPrinceTriggeredAbility
extends TriggeredAbilityImpl {
    public TheBeastDeathlessPrinceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new UntapSourceEffect());
        this.addEffect((Effect)new DrawCardSourceControllerEffect(1));
    }

    private TheBeastDeathlessPrinceTriggeredAbility(TheBeastDeathlessPrinceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent sourcePermanent = game.getPermanent(event.getSourceId());
        return sourcePermanent != null && damageEvent.isCombatDamage() && damageEvent.getPlayerId().equals(sourcePermanent.getOwnerId());
    }

    public TheBeastDeathlessPrinceTriggeredAbility copy() {
        return new TheBeastDeathlessPrinceTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature deals combat damage to its owner, untap {this} and draw a card.";
    }
}

