/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TheBrothersWarRequirementEffect
extends RequirementEffect {
    private final UUID attackingPlayerId;
    private final UUID defendingPlayerId;

    public TheBrothersWarRequirementEffect(Player attacker, Player defender) {
        super(Duration.UntilYourNextTurn);
        this.attackingPlayerId = attacker.getId();
        this.defendingPlayerId = defender.getId();
    }

    private TheBrothersWarRequirementEffect(TheBrothersWarRequirementEffect effect) {
        super((RequirementEffect)effect);
        this.attackingPlayerId = effect.attackingPlayerId;
        this.defendingPlayerId = effect.defendingPlayerId;
    }

    public TheBrothersWarRequirementEffect copy() {
        return new TheBrothersWarRequirementEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(this.attackingPlayerId);
    }

    public UUID mustAttackDefender(Ability source, Game game) {
        return this.defendingPlayerId;
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

