/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.t.TheCapitolineTriadTarget;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;

class TheCapitolineTriadCost
extends CostImpl {
    public TheCapitolineTriadCost() {
        this.addTarget((Target)new TheCapitolineTriadTarget());
        this.text = "exile any number of historic cards from your graveyard with total mana value 30 or greater";
    }

    private TheCapitolineTriadCost(TheCapitolineTriadCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        int sumManaValue = 0;
        if (this.getTargets().choose(Outcome.Exile, controllerId, source.getSourceId(), source, game)) {
            for (UUID targetId : ((Target)this.getTargets().get(0)).getTargets()) {
                Card card = game.getCard(targetId);
                if (card == null || !player.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source))) continue;
                sumManaValue += card.getManaValue();
            }
        }
        game.informPlayers("Exile historic cards with total mana value of " + sumManaValue);
        this.paid = sumManaValue >= 30;
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        int sumManaValue = 0;
        for (UUID cardId : player.getGraveyard()) {
            Card card = game.getCard(cardId);
            if (card == null) continue;
            sumManaValue += card.getManaValue();
        }
        return sumManaValue >= 30;
    }

    public TheCapitolineTriadCost copy() {
        return new TheCapitolineTriadCost(this);
    }
}

