/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class TheCavesOfAndrozaniEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("non-Saga permanent");

    TheCavesOfAndrozaniEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each non-Saga permanent, choose a counter on it. You may put an additional counter of that kind on that permanent";
    }

    private TheCavesOfAndrozaniEffect(TheCavesOfAndrozaniEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheCavesOfAndrozaniEffect copy() {
        return new TheCavesOfAndrozaniEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        target.withChooseHint("to add another counter to");
        player.choose(this.outcome, (Target)target, source, game);
        List permanents = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        block4: for (Permanent permanent : permanents) {
            CounterType counterType;
            HashSet counterTypes = new HashSet(permanent.getCounters(game).keySet());
            switch (counterTypes.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    counterType = CounterType.findByName((String)((String)RandomUtil.randomFromCollection(counterTypes)));
                    break;
                }
                default: {
                    ChoiceImpl choice = new ChoiceImpl(true);
                    choice.setMessage("Choose a type of counter to add to " + permanent.getIdName());
                    choice.setChoices(counterTypes);
                    player.choose(this.outcome, (Choice)choice, game);
                    counterType = CounterType.findByName((String)choice.getChoice());
                }
            }
            if (counterType == null) continue;
            permanent.addCounters(counterType.createInstance(), source, game);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.SAGA.getPredicate()));
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

