/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TheCinematicPhoenixEffect
extends OneShotEffect {
    TheCinematicPhoenixEffect() {
        super(Outcome.Win);
        this.staticText = "If you tapped six legendary creatures this way, you win the game";
    }

    private TheCinematicPhoenixEffect(TheCinematicPhoenixEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheCinematicPhoenixEffect copy() {
        return new TheCinematicPhoenixEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List tapped = (List)this.getValue("tappedPermanents");
        Player controller = game.getPlayer(source.getControllerId());
        if (tapped == null || tapped.isEmpty() || controller == null) {
            return false;
        }
        if (tapped.stream().allMatch(permanent -> permanent.isLegendary(game))) {
            controller.won(game);
            return true;
        }
        return false;
    }
}

