/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Mutant33DeathtouchToken;
import mage.target.Target;

class TheCurseOfFenricDestroyEffect
extends OneShotEffect {
    TheCurseOfFenricDestroyEffect() {
        super(Outcome.DestroyPermanent);
    }

    private TheCurseOfFenricDestroyEffect(TheCurseOfFenricDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheCurseOfFenricDestroyEffect copy() {
        return new TheCurseOfFenricDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Mutant33DeathtouchToken mutantToken = new Mutant33DeathtouchToken();
        ArrayList<UUID> playersToCreateToken = new ArrayList<UUID>();
        for (Target target : source.getTargets()) {
            Permanent targetCreature = game.getPermanent(target.getFirstTarget());
            if (targetCreature == null) continue;
            UUID controllerId = targetCreature.getControllerId();
            if (!targetCreature.destroy(source, game, false)) continue;
            playersToCreateToken.add(controllerId);
        }
        game.processAction();
        for (UUID controllerId : playersToCreateToken) {
            mutantToken.putOntoBattlefield(1, game, source, controllerId);
        }
        return true;
    }
}

