/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.players.Player;

class TheDarknessCrystalReturnEffect
extends OneShotEffect {
    TheDarknessCrystalReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "put target creature card exiled with {this} onto the battlefield tapped under your control with two additional +1/+1 counters on it";
    }

    private TheDarknessCrystalReturnEffect(TheDarknessCrystalReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheDarknessCrystalReturnEffect copy() {
        return new TheDarknessCrystalReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        game.setEnterWithCounters(card.getId(), new Counters(new Counter[]{CounterType.P1P1.createInstance(2)}));
        return player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

