/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;

class TheEternalWandererAttackRestrictionEffect
extends RestrictionEffect {
    TheEternalWandererAttackRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "No more than one creature can attack {this} each combat";
    }

    private TheEternalWandererAttackRestrictionEffect(TheEternalWandererAttackRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public TheEternalWandererAttackRestrictionEffect copy() {
        return new TheEternalWandererAttackRestrictionEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return true;
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null || attacker == null || source == null) {
            return true;
        }
        if (defenderId.equals(source.getSourceId())) {
            for (CombatGroup group : game.getCombat().getGroups()) {
                if (group.getDefenderId() == null || !group.getDefenderId().equals(source.getSourceId())) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

