/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TheEternalWandererExileEffect
extends OneShotEffect {
    TheEternalWandererExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile up to one target artifact or creature. Return that card to the battlefield under its owner's control at the beginning of that player's next end step.";
    }

    private TheEternalWandererExileEffect(TheEternalWandererExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            UUID exileId;
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null && controller.moveCardsToExile((Card)permanent, source, game, true, exileId = UUID.randomUUID(), sourceObject.getIdName())) {
                ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfPlayersNextEndStepDelayedTriggeredAbility((Effect)effect, permanent.getOwnerId()), source);
            }
            return true;
        }
        return false;
    }

    public TheEternalWandererExileEffect copy() {
        return new TheEternalWandererExileEffect(this);
    }
}

