/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TheEverChangingDaneCopyApplier;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;
import mage.util.functions.CopyApplier;

class TheEverChangingDaneEffect
extends OneShotEffect {
    TheEverChangingDaneEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} becomes a copy of the sacrificed creature, except it has this ability";
    }

    private TheEverChangingDaneEffect(TheEverChangingDaneEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheEverChangingDaneEffect copy() {
        return new TheEverChangingDaneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        Permanent sacrificedPermanent = CardUtil.castStream((Stream)source.getCosts().stream(), SacrificeTargetCost.class).filter(Objects::nonNull).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).findAny().orElse(null);
        if (sacrificedPermanent == null) {
            return false;
        }
        game.copyPermanent(sacrificedPermanent, permanent.getId(), source, (CopyApplier)new TheEverChangingDaneCopyApplier());
        return true;
    }
}

