/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TheFallenApartEntersEffect
extends OneShotEffect {
    TheFallenApartEntersEffect() {
        super(Outcome.Neutral);
        this.staticText = "with two arms and two legs";
    }

    private TheFallenApartEntersEffect(TheFallenApartEntersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (mageObject != null) {
            game.getState().setValue(mageObject.getId() + "_arms", (Object)2);
            game.getState().setValue(mageObject.getId() + "_legs", (Object)2);
            if (mageObject instanceof Permanent) {
                mageObject.addInfo("armslegs", CardUtil.addToolTipMarkTags((String)"Arms: 2, Legs: 2"), game);
            }
            return true;
        }
        return false;
    }

    public TheFallenApartEntersEffect copy() {
        return new TheFallenApartEntersEffect(this);
    }
}

