/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheFallenApartRestrictionEffect
extends RestrictionEffect {
    TheFallenApartRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack if it has no legs and can't block if it has no arms";
    }

    private TheFallenApartRestrictionEffect(TheFallenApartRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return (Integer)game.getState().getValue(mageObject.getId() + "_arms") > 0;
        }
        return false;
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return (Integer)game.getState().getValue(mageObject.getId() + "_legs") > 0;
        }
        return false;
    }

    public TheFallenApartRestrictionEffect copy() {
        return new TheFallenApartRestrictionEffect(this);
    }
}

