/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TheFallenApartToggleEffect
extends OneShotEffect {
    TheFallenApartToggleEffect() {
        super(Outcome.Neutral);
        this.staticText = "remove an arm or a leg from it";
    }

    private TheFallenApartToggleEffect(TheFallenApartToggleEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (controller != null && mageObject != null) {
            if (game.getState().getValue(mageObject.getId() + "_arms") == null || game.getState().getValue(mageObject.getId() + "_legs") == null) {
                return false;
            }
            int arms = (Integer)game.getState().getValue(mageObject.getId() + "_arms");
            int legs = (Integer)game.getState().getValue(mageObject.getId() + "_legs");
            if (arms > 0) {
                if (legs > 0) {
                    if (controller.chooseUse(Outcome.Detriment, "Remove an arm or a leg:", source.getSourceObject(game).getLogName(), "Arm", "Leg", source, game)) {
                        --arms;
                        game.informPlayers(mageObject.getLogName() + " loses an arm");
                    } else {
                        --legs;
                        game.informPlayers(mageObject.getLogName() + " loses a leg");
                    }
                } else {
                    --arms;
                    game.informPlayers(mageObject.getLogName() + " loses an arm");
                }
            } else if (legs > 0) {
                --legs;
                game.informPlayers(mageObject.getLogName() + " loses a leg");
            }
            game.getState().setValue(mageObject.getId() + "_arms", (Object)arms);
            game.getState().setValue(mageObject.getId() + "_legs", (Object)legs);
            ((Permanent)mageObject).addInfo("armslegs", CardUtil.addToolTipMarkTags((String)("Arms: " + arms + ", Legs: " + legs)), game);
            return true;
        }
        return false;
    }

    public TheFallenApartToggleEffect copy() {
        return new TheFallenApartToggleEffect(this);
    }
}

