/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.LandsYouControlCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheFirstTyrannicWarReplacementEffect
extends ReplacementEffectImpl {
    TheFirstTyrannicWarReplacementEffect() {
        super(Duration.EndOfStep, Outcome.BoostCreature);
    }

    private TheFirstTyrannicWarReplacementEffect(TheFirstTyrannicWarReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(LandsYouControlCount.instance.calculate(game, source, (Effect)this)), source.getControllerId(), source, game, event.getAppliedEffects());
            this.discard();
        }
        return false;
    }

    public TheFirstTyrannicWarReplacementEffect copy() {
        return new TheFirstTyrannicWarReplacementEffect(this);
    }
}

