/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheFirstTyrannicWarSecondEffect
extends OneShotEffect {
    TheFirstTyrannicWarSecondEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of each kind of counter on target creature you control";
    }

    private TheFirstTyrannicWarSecondEffect(TheFirstTyrannicWarSecondEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFirstTyrannicWarSecondEffect copy() {
        return new TheFirstTyrannicWarSecondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Set counters = permanent.getCounters(game).entrySet().stream().map(entry -> CounterType.findByName((String)((String)entry.getKey())).createInstance(((Counter)entry.getValue()).getCount())).collect(Collectors.toSet());
        if (counters.isEmpty()) {
            return false;
        }
        for (Counter counter : counters) {
            permanent.addCounters(counter, source, game);
        }
        return true;
    }
}

