/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheFleshIsWeakEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    TheFleshIsWeakEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "creatures you control with +1/+1 counters on them are artifacts in addition to their other types";
    }

    private TheFleshIsWeakEffect(TheFleshIsWeakEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            perm.addCardType(game, new CardType[]{CardType.ARTIFACT});
        }
        return true;
    }

    public TheFleshIsWeakEffect copy() {
        return new TheFleshIsWeakEffect(this);
    }

    static {
        filter.add((Predicate)CounterType.P1P1.getPredicate());
    }
}

