/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class TheFloodOfMarsEffect
extends OneShotEffect {
    TheFloodOfMarsEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a flood counter on another target creature or land. If it's a creature, it becomes a copy of {this}. If it's a land, it becomes an Island in addition to its other types";
    }

    private TheFloodOfMarsEffect(TheFloodOfMarsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFloodOfMarsEffect copy() {
        return new TheFloodOfMarsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent;
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.FLOOD.createInstance(), source, game);
        boolean isCreature = permanent.isCreature(game);
        boolean isLand = permanent.isLand(game);
        if (isCreature && (sourcePermanent = source.getSourcePermanentOrLKI(game)) != null) {
            game.copyPermanent(Duration.Custom, sourcePermanent, permanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
        }
        if (isLand) {
            game.addEffect(new AddCardSubTypeTargetEffect(SubType.ISLAND, Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

