/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.t.TheFourteenthDoctorWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class TheFourteenthDoctorCopyEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Doctor card in your graveyard that was put there from your library this turn");

    TheFourteenthDoctorCopyEffect() {
        super(Outcome.Benefit);
        this.staticText = "as a copy of a Doctor card in your graveyard that was put there from your library this turn. If you do, it gains haste until end of turn";
    }

    private TheFourteenthDoctorCopyEffect(TheFourteenthDoctorCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheFourteenthDoctorCopyEffect copy() {
        return new TheFourteenthDoctorCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Card copyFromCard = game.getCard(target.getFirstTarget());
        if (copyFromCard == null) {
            return false;
        }
        CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)copyFromCard, source.getSourceId());
        game.addEffect((ContinuousEffect)copyEffect, source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn), source);
        return true;
    }

    static {
        filter.add((Predicate)SubType.DOCTOR.getPredicate());
        filter.add((Predicate)TheFourteenthDoctorPredicate.instance);
    }

    private static enum TheFourteenthDoctorPredicate implements Predicate<Card>
    {
        instance;


        public boolean apply(Card input, Game game) {
            return TheFourteenthDoctorWatcher.checkCard(input, game);
        }
    }
}

