/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class TheFourteenthDoctorWatcher
extends Watcher {
    private final Set<MageObjectReference> set = new HashSet<MageObjectReference>();

    TheFourteenthDoctorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() == Zone.GRAVEYARD && zEvent.getFromZone() == Zone.LIBRARY) {
            this.set.add(new MageObjectReference(zEvent.getTargetId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkCard(Card card, Game game) {
        return ((TheFourteenthDoctorWatcher)game.getState().getWatcher(TheFourteenthDoctorWatcher.class)).set.stream().anyMatch(mor -> mor.refersTo((MageObject)card, game));
    }
}

