/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.TimeTravelEffect;
import mage.constants.Duration;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TheGirlInTheFireplaceTriggeredAbility
extends DelayedTriggeredAbility {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    public TheGirlInTheFireplaceTriggeredAbility() {
        super((Effect)new TimeTravelEffect(), Duration.EndOfTurn, false);
    }

    private TheGirlInTheFireplaceTriggeredAbility(TheGirlInTheFireplaceTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public TheGirlInTheFireplaceTriggeredAbility copy() {
        return new TheGirlInTheFireplaceTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedPlayerEvent)event).isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return filter.match(permanent, this.getControllerId(), (Ability)this, game);
    }

    public String getRule() {
        return "Whenever a creature you control deals combat damage to a player this turn, time travel.";
    }
}

