/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;

class TheGitrogMonsterTriggeredAbility
extends TriggeredAbilityImpl {
    public TheGitrogMonsterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), false);
    }

    private TheGitrogMonsterTriggeredAbility(TheGitrogMonsterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent != null && Zone.GRAVEYARD == zEvent.getToZone() && zEvent.getCards() != null) {
            for (Card card : zEvent.getCards()) {
                UUID cardOwnerId;
                if (card == null || (cardOwnerId = card.getOwnerId()) == null || !card.isOwnedBy(this.getControllerId()) || !card.isLand(game)) continue;
                return true;
            }
        }
        return false;
    }

    public TheGitrogMonsterTriggeredAbility copy() {
        return new TheGitrogMonsterTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more land cards are put into your graveyard from anywhere, draw a card.";
    }
}

