/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class TheGreatAuroraEffect
extends OneShotEffect {
    TheGreatAuroraEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player shuffles all cards from their hand and all permanents they own into their library, then draws that many cards. Each player may put any number of land cards from their hand onto the battlefield";
    }

    private TheGreatAuroraEffect(TheGreatAuroraEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheGreatAuroraEffect copy() {
        return new TheGreatAuroraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            HashMap<UUID, List> permanentsOwned = new HashMap<UUID, List>();
            List permanents = game.getBattlefield().getActivePermanents(source.getControllerId(), game);
            for (Object permanent : permanents) {
                List list = permanentsOwned.computeIfAbsent(permanent.getOwnerId(), k -> new ArrayList());
                list.add(permanent);
            }
            HashMap<UUID, Integer> permanentsCount = new HashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                int handCards = player.getHand().size();
                player.moveCards(player.getHand(), Zone.LIBRARY, source, game);
                List list = (List)permanentsOwned.remove(player.getId());
                permanentsCount.put(playerId, handCards + (list != null ? list.size() : 0));
                if (list == null) continue;
                for (Permanent permanent : list) {
                    player.moveCardToLibraryWithInfo((Card)permanent, source, game, Zone.BATTLEFIELD, true, true);
                }
                player.shuffleLibrary(source, game);
            }
            game.processAction();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                int count;
                player = game.getPlayer(playerId);
                if (player == null || (count = ((Integer)permanentsCount.get(playerId)).intValue()) <= 0) continue;
                player.drawCards(count, source, game);
            }
            CardsImpl toBattlefield = new CardsImpl();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player2 = game.getPlayer(playerId);
                if (player2 == null) continue;
                TargetCardInHand target = new TargetCardInHand(0, Integer.MAX_VALUE, (FilterCard)new FilterLandCard("put any number of land cards from your hand onto the battlefield"));
                player2.chooseTarget(Outcome.PutLandInPlay, player2.getHand(), (TargetCard)target, source, game);
                toBattlefield.addAll((Collection)target.getTargets());
            }
            return controller.moveCards(toBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return false;
    }
}

