/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;

class TheGreatWorkCastFromGraveyardEffect
extends AsThoughEffectImpl {
    TheGreatWorkCastFromGraveyardEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, you may cast instant and sorcery spells from any graveyard";
    }

    private TheGreatWorkCastFromGraveyardEffect(TheGreatWorkCastFromGraveyardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public TheGreatWorkCastFromGraveyardEffect copy() {
        return new TheGreatWorkCastFromGraveyardEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card = game.getCard(objectId);
        if (card != null && affectedControllerId.equals(source.getControllerId()) && StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY.match(card, game) && Zone.GRAVEYARD.equals((Object)game.getState().getZone(card.getId()))) {
            game.getState().setValue("TheGreatWork", (Object)card);
            return true;
        }
        return false;
    }
}

