/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TheKenrithsRoyalFuneralExileEffect
extends OneShotEffect {
    TheKenrithsRoyalFuneralExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to two target legendary creature cards from your graveyard. You draw X cards and you lose X life, where X is the greatest mana value among cards exiled this way";
    }

    private TheKenrithsRoyalFuneralExileEffect(TheKenrithsRoyalFuneralExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheKenrithsRoyalFuneralExileEffect copy() {
        return new TheKenrithsRoyalFuneralExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        cards.retainZone(Zone.GRAVEYARD, game);
        if (player == null || cards.isEmpty()) {
            return false;
        }
        int xValue = cards.getCards(game).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        player.drawCards(xValue, source, game);
        player.loseLife(xValue, game, source, false);
        return true;
    }
}

