/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;

class TheMasterFormedAnewCopyEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("a creature card in exile with a takeover counter on it");

    TheMasterFormedAnewCopyEffect() {
        super(Outcome.Benefit);
        this.staticText = "as a copy of a creature card in exile with a takeover counter on it";
    }

    private TheMasterFormedAnewCopyEffect(TheMasterFormedAnewCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheMasterFormedAnewCopyEffect copy() {
        return new TheMasterFormedAnewCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(0, 1, filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new CopyEffect(Duration.Custom, (MageObject)card, source.getSourceId()), source);
        return true;
    }

    static {
        filter.add((Predicate)CounterType.TAKEOVER.getPredicate());
    }
}

