/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.TheMasterGallifreysEndFirstChoice;
import mage.cards.t.TheMasterGallifreysEndPredicate;
import mage.cards.t.TheMasterGallifreysEndSecondChoice;
import mage.choices.FaceVillainousChoice;
import mage.choices.VillainousChoice;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterOpponent;
import mage.filter.FilterPlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class TheMasterGallifreysEndEffect
extends OneShotEffect {
    private static final FilterPlayer filter = new FilterOpponent("opponent with the most life among your opponents");

    TheMasterGallifreysEndEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it. If you do, choose an opponent with the most life among your opponents. That player faces a villainous choice &mdash; They lose 4 life, or you create a token that's a copy of that card";
    }

    private TheMasterGallifreysEndEffect(TheMasterGallifreysEndEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheMasterGallifreysEndEffect copy() {
        return new TheMasterGallifreysEndEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        TargetPlayer target = new TargetPlayer(filter);
        target.withNotTarget(true);
        player.chooseTarget(this.outcome, (Target)target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        return opponent != null && new FaceVillainousChoice(Outcome.LoseLife, (VillainousChoice)new TheMasterGallifreysEndFirstChoice(), (VillainousChoice)new TheMasterGallifreysEndSecondChoice(card)).faceChoice(opponent, game, source);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TheMasterGallifreysEndPredicate.instance);
    }
}

