/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class TheMycosynthGardensCopyEffect
extends OneShotEffect {
    TheMycosynthGardensCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of target nontoken artifact you control with mana value X.";
    }

    private TheMycosynthGardensCopyEffect(TheMycosynthGardensCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TheMycosynthGardensCopyEffect copy() {
        return new TheMycosynthGardensCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && copyFromPermanent != null) {
            game.copyPermanent(copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            return true;
        }
        return false;
    }
}

