/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DredgeAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TheNecrobloomDredgeEffect
extends ContinuousEffectImpl {
    TheNecrobloomDredgeEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Land cards in your graveyard have dredge 2.";
    }

    private TheNecrobloomDredgeEffect(TheNecrobloomDredgeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TheNecrobloomDredgeEffect copy() {
        return new TheNecrobloomDredgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card : player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_LAND, game)) {
            DredgeAbility ability = new DredgeAbility(2);
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        }
        return true;
    }
}

